package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.SeccionJ73;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SeccionesDaoImpl generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class SeccionJ73DaoImpl implements SeccionJ73Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SeccionJ73> rwMap = new RowMapper<SeccionJ73>() {
		public SeccionJ73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SeccionJ73(resultSet.getString("SECC004"),
					resultSet.getString("DESC004"),
					resultSet.getDate("FECHORACT004"));
		}
	};

	private RowMapper<SeccionJ73> rwMapPK = new RowMapper<SeccionJ73>() {
		public SeccionJ73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SeccionJ73(resultSet.getString("SECC004"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	public SeccionJ73 add(SeccionJ73 secciones) {
		String query = "INSERT INTO J7304S00 (SECC_004, DESC_004, FECHORACT_004) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, secciones.getSecc004(),
				secciones.getDesc004(), secciones.getFechoract004());
		return secciones;
	}

	/**
	 * Updates a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	public SeccionJ73 update(SeccionJ73 secciones) {
		String query = "UPDATE J7304S00 SET DESC_004=?, FECHORACT_004=? WHERE SECC_004=?";
		this.jdbcTemplate.update(query, secciones.getDesc004(),
				secciones.getFechoract004(), secciones.getSecc004());
		return secciones;
	}

	/**
	 * Finds a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	@Transactional(readOnly = true)
	public SeccionJ73 find(SeccionJ73 secciones) {
		String query = "SELECT t1.SECC_004 SECC004, t1.DESC_004 DESC004, t1.FECHORACT_004 FECHORACT004 FROM J7304S00 t1  WHERE t1.SECC_004 = ?  ";

		List<SeccionJ73> seccionesList = this.jdbcTemplate.query(query,
				this.rwMap, secciones.getSecc004());
		return (SeccionJ73) DataAccessUtils.uniqueResult(seccionesList);
	}

	/**
	 * Removes a single row in the Secciones table.
	 * 
	 *  secciones            Secciones
	 *
	 * @param secciones the secciones
	 */
	public void remove(SeccionJ73 secciones) {
		String query = "DELETE FROM J7304S00 WHERE SECC_004=?";
		this.jdbcTemplate.update(query, secciones.getSecc004());
	}

	/**
	 * Finds a list of rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<SeccionJ73> findAll(SeccionJ73 secciones,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		query.append("FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<SeccionJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<SeccionJ73> findAllLike(SeccionJ73 secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		query.append("FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<SeccionJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Long
	 *
	 * @param secciones the secciones
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(SeccionJ73 secciones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secciones);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param secciones the secciones
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(SeccionJ73 secciones, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7304S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Secciones selected for rup_table.
	 * 
	 *  secciones            Secciones
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Secciones>>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<SeccionJ73>> reorderSelection(SeccionJ73 secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.SECC_004 SECC004,t1.DESC_004 DESC004,t1.FECHORACT_004 FECHORACT004 ");
		// FROM
		query.append("FROM J7304S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, SeccionJ73.class, filterParamList,
				"SECC_004");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<SeccionJ73>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secciones entity.
	 * 
	 *  secciones            Secciones Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param secciones the secciones
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(SeccionJ73 secciones) {

		StringBuilder where = new StringBuilder(
				SeccionJ73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secciones != null && secciones.getSecc004() != null) {
			where.append(" AND t1.SECC_004 = ?");
			params.add(secciones.getSecc004());
		}
		if (secciones != null && secciones.getDesc004() != null) {
			where.append(" AND t1.DESC_004 = ?");
			params.add(secciones.getDesc004());
		}
		if (secciones != null && secciones.getFechoract004() != null) {
			where.append(" AND t1.FECHORACT_004 = ?");
			params.add(secciones.getFechoract004());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secciones entity.
	 * 
	 *  secciones            Secciones Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param secciones the secciones
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(SeccionJ73 secciones,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SeccionJ73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secciones != null && secciones.getSecc004() != null) {
			where.append(" AND UPPER(t1.SECC_004) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secciones.getSecc004().toUpperCase() + "%");
			} else {
				params.add("%" + secciones.getSecc004().toUpperCase() + "%");
			}
			where.append(" AND t1.SECC_004 IS NOT NULL");
		}
		if (secciones != null && secciones.getDesc004() != null) {
			where.append(" AND UPPER(t1.DESC_004) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secciones.getDesc004().toUpperCase() + "%");
			} else {
				params.add("%" + secciones.getDesc004().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_004 IS NOT NULL");
		}
		if (secciones != null && secciones.getFechoract004() != null) {
			where.append(" AND t1.FECHORACT_004 = ?");
			params.add(secciones.getFechoract004());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
